<?php

/**
 * Class that operate on table 'employeepersonnel'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2014-03-09 11:49
 */
class EmployeepersonnelMySqlDAO implements EmployeepersonnelDAO {

    /**
     * Get Domain object by primry key
     *
     * @param String $id primary key
     * @return EmployeepersonnelMySql
     */
    public function load($id) {
        $sql = 'SELECT * FROM employeepersonnel WHERE employeepersonnelid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->getRow($sqlQuery);
    }

    /**
     * Get all records from table
     */
    public function queryAll() {
        $sql = 'SELECT * FROM employeepersonnel';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Get all records from table ordered by field
     *
     * @param $orderColumn column name
     */
    public function queryAllOrderBy($orderColumn) {
        $sql = 'SELECT * FROM employeepersonnel ORDER BY ' . $orderColumn;
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Delete record from table
     * @param employeepersonnel primary key
     */
    public function delete($employeepersonnelid) {
        $sql = 'DELETE FROM employeepersonnel WHERE employeepersonnelid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($employeepersonnelid);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Insert record to table
     *
     * @param EmployeepersonnelMySql employeepersonnel
     */
    public function insert($employeepersonnel) {
        $sql = 'INSERT INTO employeepersonnel (employeeid, employeepersonnelvalue, employeepersonnelnote, conditions, userid, employeepersonneldate, employeepersonneltype,empdeptbefor,empdeptafter,paymenttype,payid,payid2,checknum,isMandobReward,dailyentryid,deviceid,employeedeviceid) VALUES (?, ?, ?, ?, ?, ?, ?,?,?,?,?,?,?,?,?,?,?)';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->setNumber($employeepersonnel->employeeid);
        $sqlQuery->set($employeepersonnel->employeepersonnelvalue);
        $sqlQuery->setString2($employeepersonnel->employeepersonnelnote);
        $sqlQuery->setNumber($employeepersonnel->conditions);
        $sqlQuery->setNumber($employeepersonnel->userid);
        $sqlQuery->set($employeepersonnel->employeepersonneldate);
        $sqlQuery->set($employeepersonnel->employeepersonneltype);

        $sqlQuery->setNumber($employeepersonnel->empdeptbefor);
        $sqlQuery->setNumber($employeepersonnel->empdeptafter);
        $sqlQuery->setNumber($employeepersonnel->paymenttype);
        $sqlQuery->setNumber($employeepersonnel->payid);
        $sqlQuery->setNumber($employeepersonnel->payid2);
        $sqlQuery->set($employeepersonnel->checknum);
        $sqlQuery->setNumber((int) $employeepersonnel->isMandobReward);
        $sqlQuery->setNumber((int) $employeepersonnel->dailyentryid);
        $sqlQuery->set($employeepersonnel->deviceid);
        $sqlQuery->set($employeepersonnel->employeedeviceid);

        $id = $this->executeInsert($sqlQuery);
        $employeepersonnel->employeepersonnelid = $id;
        return $id;
    }

    /**
     * Update record in table
     *
     * @param EmployeepersonnelMySql employeepersonnel
     */
    public function update($employeepersonnel) {
        $sql = 'UPDATE employeepersonnel SET employeeid = ?, employeepersonnelvalue = ?, employeepersonnelnote = ?, conditions = ?, userid = ?, employeepersonneldate = ?, employeepersonneltype = ?,paymenttype = ?,payid = ?,payid2 = ?,checknum = ?,isMandobReward=?,dailyentryid=?,deviceid=?,employeedeviceid=? WHERE employeepersonnelid = ?';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->setNumber($employeepersonnel->employeeid);
        $sqlQuery->set($employeepersonnel->employeepersonnelvalue);
        $sqlQuery->set($employeepersonnel->employeepersonnelnote);
        $sqlQuery->setNumber($employeepersonnel->conditions);
        $sqlQuery->setNumber($employeepersonnel->userid);
        $sqlQuery->set($employeepersonnel->employeepersonneldate);
        $sqlQuery->set($employeepersonnel->employeepersonneltype);
        $sqlQuery->setNumber($employeepersonnel->paymenttype);
        $sqlQuery->setNumber($employeepersonnel->payid);
        $sqlQuery->setNumber($employeepersonnel->payid2);
        $sqlQuery->set($employeepersonnel->checknum);
        $sqlQuery->setNumber((int) $employeepersonnel->isMandobReward);
        $sqlQuery->setNumber((int) $employeepersonnel->dailyentryid);
        $sqlQuery->set($employeepersonnel->deviceid);
        $sqlQuery->set($employeepersonnel->employeedeviceid);


        $sqlQuery->setNumber($employeepersonnel->employeepersonnelid);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Delete all rows
     */
    public function clean() {
        $sql = 'DELETE FROM employeepersonnel';
        $sqlQuery = new SqlQuery($sql);
        return $this->executeUpdate($sqlQuery);
    }

    public function queryByEmployeeid($value) {
        $sql = 'SELECT * FROM employeepersonnel WHERE employeeid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByEmployeepersonnelvalue($value) {
        $sql = 'SELECT * FROM employeepersonnel WHERE employeepersonnelvalue = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByEmployeepersonnelnote($value) {
        $sql = 'SELECT * FROM employeepersonnel WHERE employeepersonnelnote = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByConditions($value) {
        $sql = 'SELECT * FROM employeepersonnel WHERE conditions = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByUserid($value) {
        $sql = 'SELECT * FROM employeepersonnel WHERE userid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByEmployeepersonneldate($value) {
        $sql = 'SELECT * FROM employeepersonnel WHERE employeepersonneldate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByEmployeepersonneltype($value) {
        $sql = 'SELECT * FROM employeepersonnel WHERE employeepersonneltype = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function deleteByEmployeeid($value) {
        $sql = 'DELETE FROM employeepersonnel WHERE employeeid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByEmployeepersonnelvalue($value) {
        $sql = 'DELETE FROM employeepersonnel WHERE employeepersonnelvalue = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByEmployeepersonnelnote($value) {
        $sql = 'DELETE FROM employeepersonnel WHERE employeepersonnelnote = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByConditions($value) {
        $sql = 'DELETE FROM employeepersonnel WHERE conditions = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByUserid($value) {
        $sql = 'DELETE FROM employeepersonnel WHERE userid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByEmployeepersonneldate($value) {
        $sql = 'DELETE FROM employeepersonnel WHERE employeepersonneldate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByEmployeepersonneltype($value) {
        $sql = 'DELETE FROM employeepersonnel WHERE employeepersonneltype = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Read row
     *
     * @return EmployeepersonnelMySql
     */
    protected function readRow($row) {
        $employeepersonnel = new Employeepersonnel();

        $employeepersonnel->employeepersonnelid = isset($row['employeepersonnelid']) ? $row['employeepersonnelid'] : '';
        $employeepersonnel->employeeid = isset($row['employeeid']) ? $row['employeeid'] : '';
        $employeepersonnel->employeepersonnelvalue = isset($row['employeepersonnelvalue']) ? $row['employeepersonnelvalue'] : '';
        $employeepersonnel->employeepersonnelnote = isset($row['employeepersonnelnote']) ? $row['employeepersonnelnote'] : '';
        $employeepersonnel->conditions = isset($row['conditions']) ? $row['conditions'] : '';
        $employeepersonnel->userid = isset($row['userid']) ? $row['userid'] : '';
        $employeepersonnel->employeepersonneldate = isset($row['employeepersonneldate']) ? $row['employeepersonneldate'] : '';
        $employeepersonnel->employeepersonneltype = isset($row['employeepersonneltype']) ? $row['employeepersonneltype'] : '';
        $employeepersonnel->dailyentryid = isset($row['dailyentryid']) ? $row['dailyentryid'] : '';

        $employeepersonnel->employeeName = isset($row['employeeName']) ? $row['employeeName'] : '';
        $employeepersonnel->done = isset($row['done']) ? $row['done'] : '';

        $employeepersonnel->empdeptbefor = isset($row['empdeptbefor']) ? $row['empdeptbefor'] : '';
        $employeepersonnel->empdeptafter = isset($row['empdeptafter']) ? $row['empdeptafter'] : '';
        $employeepersonnel->empdeptafter = isset($row['salarymonth']) ? $row['salarymonth'] : '';
        $employeepersonnel->total = isset($row['total']) ? $row['total'] : '';

        $employeepersonnel->deviceid = isset($row['deviceid']) ? $row['deviceid'] : '';
        $employeepersonnel->employeedeviceid = isset($row['employeedeviceid']) ? $row['employeedeviceid'] : '';


        $employeepersonnel->paymenttype = isset($row['paymenttype']) ? $row['paymenttype'] : '';
        $employeepersonnel->payid = isset($row['payid']) ? $row['payid'] : '';
        $employeepersonnel->payid2 = isset($row['payid2']) ? $row['payid2'] : '';
        $employeepersonnel->checknum = isset($row['checknum']) ? $row['checknum'] : '';
        $employeepersonnel->isMandobReward = isset($row['isMandobReward']) ? $row['isMandobReward'] : '';

        return $employeepersonnel;
    }

    protected function getList($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        $ret = array();
        for ($i = 0; $i < count($tab); $i++) {
            $ret[$i] = $this->readRow($tab[$i]);
        }
        return $ret;
    }

    /**
     * Get row
     *
     * @return EmployeepersonnelMySql
     */
    protected function getRow($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        if (count($tab) == 0) {
            return null;
        }
        return $this->readRow($tab[0]);
    }

    /**
     * Execute sql query
     */
    protected function execute($sqlQuery) {
        return QueryExecutor::execute($sqlQuery);
    }

    /**
     * Execute sql query
     */
    protected function executeUpdate($sqlQuery) {
        return QueryExecutor::executeUpdate($sqlQuery);
    }

    /**
     * Query for one row and one column
     */
    protected function querySingleResult($sqlQuery) {
        return QueryExecutor::queryForString($sqlQuery);
    }

    /**
     * Insert row to table
     */
    protected function executeInsert($sqlQuery) {
        return QueryExecutor::executeInsert($sqlQuery);
    }

}

?>